<?php

/**
 * Armanet Wordpress Plugin.
 *
 * Armanet is modern advertising for the 2A industry to drive immediate,
 * measurable, consumer demand. This plugin helps integrate your business
 * with our ad tech solutions.
 *
 * @see     https://armanet.co
 * @since   1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:       Armanet
 * Plugin URI:        https://developer.armanet.co
 * Description:       Armanet is modern advertising for the 2A industry to drive immediate, measurable, consumer demand. This plugin helps integrate your business with our ad tech solutions.
 * Version:           1.0.4
 * Requires at least: 5.2
 * Requires PHP:      5.2
 * Author:            Armanet
 * Author URI:        https://armanet.co/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       armanet
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    exit;
}

define('ARMANET_VERSION', '1.0.4');

function activate_armanet()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-armanet-activator.php';
    Armanet_Activator::activate();
}

function deactivate_armanet()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-armanet-deactivator.php';
    Armanet_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_armanet');
register_deactivation_hook(__FILE__, 'deactivate_armanet');

require plugin_dir_path(__FILE__) . 'includes/class-armanet.php';
require plugin_dir_path(__FILE__) . 'public/class-armanet-controller-feed.php';

function run_armanet()
{
    $plugin = new Armanet();
    $plugin->run();
}

run_armanet();
